/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.sandy;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;

public interface Sandy {
    public static final class_2758 SANDINESS = ModBlockProperties.SANDINESS;
    public static final class_2758 SAND_AGE = ModBlockProperties.SAND_AGE;
    public static final Supplier<BiMap<class_2248, class_2248>> NORMAL_TO_SANDY = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_2246.field_10340, (Object)ModBlocks.SANDY_STONE.get()).put((Object)class_2246.field_10440, (Object)ModBlocks.SANDY_STONE_STAIRS.get()).put((Object)class_2246.field_10454, (Object)ModBlocks.SANDY_STONE_SLAB.get()).put((Object)ModBlocks.STONE_WALL.get(), (Object)ModBlocks.SANDY_STONE_WALL.get()).put((Object)class_2246.field_10445, (Object)ModBlocks.SANDY_COBBLESTONE.get()).put((Object)class_2246.field_10596, (Object)ModBlocks.SANDY_COBBLESTONE_STAIRS.get()).put((Object)class_2246.field_10351, (Object)ModBlocks.SANDY_COBBLESTONE_SLAB.get()).put((Object)class_2246.field_10625, (Object)ModBlocks.SANDY_COBBLESTONE_WALL.get()).put((Object)class_2246.field_10056, (Object)ModBlocks.SANDY_STONE_BRICKS.get()).put((Object)class_2246.field_10552, (Object)ModBlocks.SANDY_CHISELED_STONE_BRICKS.get()).put((Object)class_2246.field_10392, (Object)ModBlocks.SANDY_STONE_BRICK_STAIRS.get()).put((Object)class_2246.field_10131, (Object)ModBlocks.SANDY_STONE_BRICK_SLAB.get()).put((Object)class_2246.field_10252, (Object)ModBlocks.SANDY_STONE_BRICK_WALL.get());
        return builder.build();
    });
    public static final Supplier<BiMap<class_2248, class_2248>> SANDY_TO_NORMAL = Suppliers.memoize(() -> NORMAL_TO_SANDY.get().inverse());

    public static Optional<class_2680> getSandy(class_2680 state) {
        return Sandy.getSandy(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2680> getUnSandy(class_2680 state) {
        return Sandy.getUnSandy(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getUnSandy(class_2248 block) {
        return Optional.ofNullable((class_2248)SANDY_TO_NORMAL.get().get((Object)block));
    }

    public static Optional<class_2248> getSandy(class_2248 block) {
        return Optional.ofNullable((class_2248)NORMAL_TO_SANDY.get().get((Object)block));
    }

    default public boolean interactWithPlayer(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        Optional<class_2680> unSandy = Sandy.getUnSandy(state);
        if (unSandy.isPresent() && item instanceof class_1821) {
            level.method_8396(player, pos, class_3417.field_15074, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), (class_6017)class_6019.method_35017((int)3, (int)5));
            stack.method_7956(1, (class_1309)player, l -> l.method_20236(hand));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                level.method_8501(pos, unSandy.get());
                if ((Integer)state.method_11654((class_2769)ModBlockProperties.SANDINESS) == 0) {
                    level.method_8501(pos, unSandy.get());
                }
                if ((Integer)state.method_11654((class_2769)ModBlockProperties.SANDINESS) == 1) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)ModBlockProperties.SANDINESS, (Comparable)Integer.valueOf(0)));
                }
                if (!player.method_7337() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    class_2248.method_36992((class_1937)level, (class_2338)pos, (class_2350)hitResult.method_17780(), (class_1799)new class_1799((class_1935)ModBlocks.SAND_LAYER_BLOCK.get()));
                }
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return true;
        }
        return false;
    }

    default public void spawnParticles(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        class_2338 blockpos;
        class_2680 blockstate;
        if (random.method_43048(10) == 1 && !(blockstate = level.method_8320(blockpos = pos.method_10074())).method_26206((class_1922)level, blockpos, class_2350.field_11036)) {
            double d0 = (double)pos.method_10263() + random.method_43058();
            double d1 = (double)pos.method_10264() - 0.05;
            double d2 = (double)pos.method_10260() + random.method_43058();
            if ((Integer)state.method_11654((class_2769)ModBlockProperties.SANDINESS) == 0 && random.method_43048(10) == 1) {
                level.method_8406((class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), d0, d1, d2, 0.0, 0.0, 0.0);
            } else {
                level.method_8406((class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean isRandomSandyPos(class_2338 pos) {
        Random posRandom = new Random(class_3532.method_15389((class_2382)pos));
        return posRandom.nextInt(5) > 2;
    }

    default public int getAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.getAgeProperty());
    }

    default public class_2758 getAgeProperty() {
        return SAND_AGE;
    }

    default public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = level.method_8320(belowPos);
        Optional<class_2680> unSandy = Sandy.getUnSandy(state);
        Optional<class_2680> Sandy2 = Sandy.getSandy(belowState);
        if (belowState.method_26215() && (Integer)state.method_11654((class_2769)SAND_AGE) > 0) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)SAND_AGE, (Comparable)Integer.valueOf(this.getAge(state) - 1)));
            level.method_8501(belowPos, ModBlocks.SAND_LAYER_BLOCK.get().method_9564());
        } else if (belowState.method_26164(ModTags.DOUBLE_SANDABLE) && Sandy.isRandomSandyPos(pos) && Sandy2.isPresent()) {
            if ((Integer)state.method_11654((class_2769)SANDINESS) == 1) {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)SANDINESS, (Comparable)Integer.valueOf(0)));
            }
            if ((Integer)state.method_11654((class_2769)SANDINESS) == 0 && unSandy.isPresent()) {
                level.method_8501(pos, unSandy.get());
            }
            level.method_8501(belowPos, Sandy2.get());
        }
    }

    default public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 neighborPos, boolean isMoving) {
        Optional<class_2680> unSandy = Sandy.getUnSandy(state);
        class_2680 neighborState = level.method_8320(neighborPos);
        if (neighborState.method_26227().method_39360((class_3611)class_3612.field_15909) && unSandy.isPresent()) {
            level.method_8501(pos, unSandy.get());
            class_1799 stack = new class_1799((class_1935)ModBlocks.SAND_LAYER_BLOCK.get());
            class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
            level.method_8396(null, pos, class_3417.field_15074, class_3419.field_15245, 1.0f, 1.0f);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                serverLevel.method_14199((class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
            }
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11206, class_2246.field_10102.method_9564()), (class_6017)class_6019.method_35017((int)3, (int)5));
        }
    }
}

